package com.example.sefinsa_app.ui.avales.fotos;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;

import com.example.sefinsa_app.R;

import java.util.ArrayList;
import java.util.List;

import okhttp3.MultipartBody;

public class AvalesFotosDialogFragment extends DialogFragment implements AvalesFotosFragment.OnPhotosSelectedListener {

    private OnDialogDismissedListener listener;

    public interface OnDialogDismissedListener {
        void onDialogDismissed(Bundle bundle); // Método para enviar datos al fragmento o actividad
    }
    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval,
                                 ArrayList<String> pathsGarantiasAval,
                                 ArrayList<String> pathsIneAval,
                                 ArrayList<String> pathsFotoAval,
                                 ArrayList<String> pathsFachadaAval,
                                 List<MultipartBody.Part>archivosGeneral) {

        Fragment parentFragment = getParentFragment();
        if (parentFragment instanceof AvalesFotosFragment.OnPhotosSelectedListener) {
            ((AvalesFotosFragment.OnPhotosSelectedListener) parentFragment).onPhotosSelected(
                    pathsComprobantesAval, pathsGarantiasAval, pathsIneAval, pathsFotoAval, pathsFachadaAval, archivosGeneral);
        }
        dismiss();
    }
    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dialog_container, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        AvalesFotosFragment avalesFotosFragment = new AvalesFotosFragment();

        // Verificar si tenemos argumentos y si el tipo es "2"
        if (getArguments() != null) {
            String tipo = getArguments().getString("tipo");

            // Si tipo es "2", pasar los datos al fragmento
            if ("2".equals(tipo)) {
                String avalJson = getArguments().getString("aval");
                String avalId = getArguments().getString("avalId");

                Log.d("AvalesFotosDialog", "Recibido tipo: " + tipo);
                Log.d("AvalesFotosDialog", "JSON de Aval: " + avalJson);
                Log.d("AvalesFotosDialog", "ID de Aval: " + avalId);

                Bundle bundle = new Bundle();
                bundle.putString("aval", avalJson);
                bundle.putString("avalId", avalId);

                avalesFotosFragment.setArguments(bundle);

            } else {
                Log.d("AvalesFotosDialog", "Cargando vista normal, sin datos");
            }
        } else {
            Log.d("AvalesFotosDialog", "No se recibieron argumentos.");
        }

        getChildFragmentManager().beginTransaction()
                .replace(R.id.dialog_fragment_container, avalesFotosFragment)
                .commit();

        // Configurar el botón para cerrar el diálogo
        Button closeButton = view.findViewById(R.id.close_buttonF);
        closeButton.setOnClickListener(v -> dismiss());
    }

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog() != null) {
            getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        }
    }
}
